import { Apple, Mail, Phone, MapPin, Instagram, Facebook, Youtube } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer-nutrition">
      <div className="container">
        <div className="footer-content-nutrition">
          <div className="footer-brand-nutrition">
            <div className="footer-logo-nutrition">
              <Apple size={28} />
              <span className="footer-logo-text-nutrition">NutriCare</span>
            </div>
            <p className="footer-description-nutrition">
              Профессиональные консультации по питанию для вашего здоровья и благополучия
            </p>
          </div>
          <div className="footer-links-nutrition">
            <div className="footer-column-nutrition">
              <h4 className="footer-title-nutrition">Контакты</h4>
              <div className="footer-contact-nutrition">
                <div className="footer-contact-item-nutrition">
                  <Mail size={18} />
                  <span>info@nutricare.ru</span>
                </div>
                <div className="footer-contact-item-nutrition">
                  <Phone size={18} />
                  <span>+7 (495) 123-45-67</span>
                </div>
                <div className="footer-contact-item-nutrition">
                  <MapPin size={18} />
                  <span>Москва, ул. Здоровья, 1</span>
                </div>
              </div>
            </div>
            <div className="footer-column-nutrition">
              <h4 className="footer-title-nutrition">Социальные сети</h4>
              <div className="footer-social-nutrition">
                <a href="#" className="footer-social-link-nutrition" aria-label="Instagram">
                  <Instagram size={20} />
                </a>
                <a href="#" className="footer-social-link-nutrition" aria-label="Facebook">
                  <Facebook size={20} />
                </a>
                <a href="#" className="footer-social-link-nutrition" aria-label="YouTube">
                  <Youtube size={20} />
                </a>
              </div>
            </div>
          </div>
        </div>
        <div className="footer-bottom-nutrition">
          <p>&copy; 2025 NutriCare. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

